function cmap = importeditedcolormap( filename )
% cmap = importeditedcolormap( filename )
% 
% Import a colour map png created with writecolormap.
% 
% The user can change the colour of pixels in the right column, using an
% image editing program, like the Gimp or Photoshop. The matlab function importeditedcolormap
% can be used to read in the edited colour map, and convert it into a
% matlab colourmap, which can be used to save the gif with the new colours
% using imwrite.
% 
% See also importeditedcolormap, showcolormap, imwrite


[ IM ] = imread( filename );

cmap = double( squeeze( IM( :, 2, : ) ) ) / 255;